unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Borland.Vcl.StdCtrls, System.ComponentModel;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    ListBox1: TListBox;
    Label2: TLabel;
    Button1: TButton;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Button2: TButton;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    tablicaTrybowKartyGraf :array of TDeviceMode;
  public
  protected
    procedure WMDisplayChange(var Msg :TMessage); message WM_DISPLAYCHANGE;
  end;

var
  Form1: TForm1;

implementation

{$R *.nfm}

procedure TForm1.FormCreate(Sender: TObject);
const
  ENUM_CURRENT_SETTINGS=Cardinal(-1);
  ENUM_REGISTRY_SETTINGS=Cardinal(-2);
var
  i :Integer;
  wynik :Boolean;
  trybKartyGraf,aktualnyTrybKartyGraf :TDeviceMode;
  S :String;
begin
//Pobieranie parametrow aktualnego trybu
EnumDisplaySettings(nil,ENUM_CURRENT_SETTINGS,aktualnyTrybKartyGraf);

//Pobieranie dostepnych trybow wyswietlania
i:=0;
wynik:=True;
while wynik do
    begin
    wynik:=EnumDisplaySettings(nil,i,trybKartyGraf);
    if wynik then
      begin
      //przechowywanie informacji w tablicy
      SetLength(tablicaTrybowKartyGraf,i+1);
      tablicaTrybowKartyGraf[i]:=trybKartyGraf;

      //pobieranie nazwy karty graficznej (w kazdym modzie taka sama)
      if i=0 then Label1.Caption:='Dostpne tryby wywietlania na '+trybKartyGraf.dmDeviceName;

      //przygotowywanie opisu
      S:=IntToStr(trybKartyGraf.dmPelsWidth)+' x '+IntToStr(trybKartyGraf.dmPelsHeight)+',  ';
      if (Win32Platform=VER_PLATFORM_WIN32_NT) then S:=S+IntToStr(trybKartyGraf.dmDisplayFrequency)+' Hz,  ';
      S:=S+IntToStr(trybKartyGraf.dmBitsPerPel)+' bitw';
      case (trybKartyGraf.dmBitsPerPel) of
        1: S:=S+' (Monochromatyczny)';
        2: S:=S+' (4 kolory)';
        4: S:=S+' (16 kolorw)';
        8: S:=S+' (256 kolorw)';
        16: S:=S+' (High Color)';
        32: S:=S+' (True Color)';
      end;

      //opis dodawany do listy
      ListBox1.Items.Add(S);

      //rozpoznawanie aktualnego trybu
      if (trybKartyGraf.dmPelsWidth=aktualnyTrybKartyGraf.dmPelsWidth) and
         (trybKartyGraf.dmPelsHeight=aktualnyTrybKartyGraf.dmPelsHeight) and
         (trybKartyGraf.dmDisplayFrequency=aktualnyTrybKartyGraf.dmDisplayFrequency) and
         (trybKartyGraf.dmBitsPerPel=aktualnyTrybKartyGraf.dmBitsPerPel)
        then
          begin
          ListBox1.ItemIndex:=i;
          Label2.Caption:='Aktualny tryb wywietlania:'+#13+S;
          end;
      end;
    Inc(i);
    end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var S :String;
begin
case (ChangeDisplaySettings(tablicaTrybowKartyGraf[ListBox1.ItemIndex],0)) of
  DISP_CHANGE_SUCCESSFUL: S:='Tryb wywietlania zosta zmieniony';
  DISP_CHANGE_RESTART: S:='Niezbdne jest ponowne uruchomienie komputera';
  DISP_CHANGE_BADFLAGS: S:='Bdne ustawienia';
  DISP_CHANGE_FAILED: S:='Sterownik ekranu odrzuci ustawienia';
  DISP_CHANGE_BADMODE: S:='Wybrany tryb ekranu nie jest obsugiwany';
  DISP_CHANGE_NOTUPDATED: S:='Nowe ustawienia nie mogy zosta zapisane do rejestru (brak uprawnie)';
  else
  S:='ChangeDisplaySettings: Efekt nierozpoznany';
end;
ShowMessage(S);
end;

procedure TForm1.WMDisplayChange(var Msg :TMessage);
begin
Label4.Caption:=DateTimeToStr(Now);
Label6.Caption:=IntToStr(LOWORD(Msg.LParam))+' x '+IntToStr(HIWORD(Msg.LParam))+', kolory: '+IntToStr(Msg.WParam)+' bity';
ListBox1.Clear; FormCreate(nil); //zaznaczenie pozycji w ListBox1
end;


procedure TForm1.Button2Click(Sender: TObject);
begin
SendMessage(Form1.Handle,WM_DISPLAYCHANGE,
  GetDeviceCaps(Form1.Canvas.Handle,PLANES)*
  GetDeviceCaps(Form1.Canvas.Handle,BITSPIXEL),
  DWORD(Screen.Height shl 16)+Screen.Width);
end;

end.
